/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobRandomPos
extends AbstractPathJob {
    @NotNull
    protected final BlockPos destination;
    protected final int minDistFromStart;
    private static Random random = new Random();
    private final int maxDistToDest;

    public PathJobRandomPos(World world, @NotNull BlockPos start, int minDistFromStart, int range, LivingEntity entity) {
        super(world, start, start, range, new PathResult(), entity);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = range;
        Tuple<Direction, Direction> dir = BlockPosUtil.getRandomDirectionTuple(random);
        this.destination = start.func_177967_a((Direction)dir.func_76341_a(), minDistFromStart).func_177967_a((Direction)dir.func_76340_b(), minDistFromStart);
    }

    public PathJobRandomPos(World world, @NotNull BlockPos start, int minDistFromStart, int searchRange, int maxDistToDest, LivingEntity entity, @NotNull BlockPos dest) {
        super(world, start, dest, searchRange, new PathResult(), entity);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = maxDistToDest;
        this.destination = dest;
    }

    @Override
    @Nullable
    protected Path search() {
        if ((Integer)MineColonies.getConfig().getServer().pathfindingDebugVerbosity.get() > 0) {
            Log.getLogger().info(String.format("Pathfinding from [%d,%d,%d] in the direction of [%d,%d,%d]", this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p(), this.destination.func_177958_n(), this.destination.func_177956_o(), this.destination.func_177952_p()));
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        return Math.sqrt(this.destination.func_177951_i((Vector3i)new BlockPos(pos.func_177958_n(), this.destination.func_177956_o(), pos.func_177952_p())));
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        return random.nextInt(10) == 0 && this.start.func_177951_i((Vector3i)n.pos) > (double)(this.minDistFromStart * this.minDistFromStart) && this.isWalkableSurface(this.world.func_180495_p(n.pos.func_177977_b()), n.pos.func_177977_b()) == AbstractPathJob.SurfaceType.WALKABLE && this.destination.func_177951_i((Vector3i)n.pos) < (double)(this.maxDistToDest * this.maxDistToDest);
    }

    @Override
    protected double getNodeResultScore(@NotNull Node n) {
        return this.destination.func_177951_i((Vector3i)n.pos);
    }

    public boolean posAndRangeMatch(int range, BlockPos pos) {
        return this.destination != null && pos != null && range == this.maxDistToDest && this.destination.equals((Object)pos);
    }
}

